#!/bin/sh

#  collectinfo.command
#
#
#  Created by PositiveGrid.
#

clear
echo "********** PositiveGrid Support Tool V0.4.10 **********"

# Function
showspinner()
{
  pid=$! # Process Id of the previous running command

  spin='-\|/'

  i=0
  while kill -0 $pid 2>/dev/null
  do
    i=$(( (i+1) %4 ))
    printf "\r${spin:$i:1}"
    sleep .1
  done
}

# Going to the directory of script
cd "$(dirname "${BASH_SOURCE[0]}")"

# Cleaning old data
rm *-*-*-*-*.zip 2> /dev/null

# Generating UUID
uuid=$(uuidgen)

# Generating system info
sw_vers > systeminfo.txt
echo >> systeminfo.txt
uname -a >> systeminfo.txt
echo >> systeminfo.txt
system_profiler SPHardwareDataType >> systeminfo.txt &
showspinner
system_profiler SPMemoryDataType >> systeminfo.txt &
showspinner
system_profiler SPAudioDataType >> systeminfo.txt &
showspinner
system_profiler SPDisplaysDataType >> systeminfo.txt &
showspinner
system_profiler SPEthernetDataType >> systeminfo.txt &
showspinner

# Collecting data
zip -mr ${uuid}.zip ~/Library/Caches/[Bb][Ii][Aa][Ss]* 1> /dev/null &
showspinner
zip -r ${uuid}.zip /Library/Logs -i \*[Bb][Ii][Aa][Ss]\* 1> /dev/null &
showspinner
zip -r ${uuid}.zip ~/Library/Logs -i \*[Bb][Ii][Aa][Ss]\* 1> /dev/null &
showspinner
zip -mr ${uuid}.zip ~/Library/Logs/PositiveGrid 1> /dev/null &
showspinner
zip ${uuid}.zip ~/Library/Application\ Support/[Bb][Ii][Aa][Ss]* 1> /dev/null &
showspinner
zip -mr ${uuid}.zip ~/Library/Application\ Support/PositiveGrid 1> /dev/null &
showspinner
zip -r ${uuid}.zip ~/Documents/[Bb][Ii][Aa][Ss]* 1> /dev/null &
showspinner
zip -r ${uuid}.zip ~/Documents/PositiveGrid 1> /dev/null &
showspinner
zip -m ${uuid}.zip systeminfo.txt 1> /dev/null &
showspinner

echo
echo "    Please Send \033[31m${uuid}.zip\033[0m to PositiveGrid for analysis."
echo
echo
echo
